<?php $__env->startSection('content'); ?>
    <section class="section bg--light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <table class="table custom--table table-responsive--lg escrow-table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Escrow Number'); ?></th>
                                <th><?php echo app('translator')->get('Title'); ?></th>
                                <th><?php echo app('translator')->get('Buyer - Seller'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                                <th><?php echo app('translator')->get('Category'); ?></th>
                                <th><?php echo app('translator')->get('Charge'); ?></th>
                                <th><?php echo app('translator')->get('Charge Payer'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $escrows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $escrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($escrow->escrow_number); ?></td>
                                    <td><?php echo e(__($escrow->title)); ?></td>
                                    <td>
                                        <?php echo app('translator')->get('I\'m'); ?> <?php if($escrow->buyer_id == auth()->user()->id): ?>
                                            <?php echo app('translator')->get('buying from'); ?>
                                            <?php echo e(__(@$escrow->seller->username ?? $escrow->invitation_mail)); ?>

                                        <?php else: ?>
                                            <?php echo app('translator')->get('selling to'); ?>
                                            <?php echo e(__(@$escrow->buyer->username ?? $escrow->invitation_mail)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e(showAmount($escrow->amount)); ?></td>
                                    <td><?php echo e($escrow->category->name); ?></td>
                                    <td>
                                        <?php echo e(showAmount($escrow->charge)); ?></td>
                                    <td>
                                        <?php if($escrow->charge_payer == Status::CHARGE_PAYER_SELLER): ?>
                                            <span class="badge badge--dark"><?php echo app('translator')->get('Seller'); ?></span>
                                        <?php elseif($escrow->charge_payer == Status::CHARGE_PAYER_BUYER): ?>
                                            <span class="badge badge--info"><?php echo app('translator')->get('Buyer'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge--success"><?php echo app('translator')->get('50%-50%'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo $escrow->escrowStatus ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('user.escrow.details', $escrow->id)); ?>" class="btn btn-base--outline btn-sm detailBtn "><i
                                                class="la la-desktop"></i> <?php echo app('translator')->get('Details'); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if($escrows->hasPages()): ?>
                    <div class="mt-3">
                        <?php echo e($escrows->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/title/escrow/account/core/resources/views/templates/basic/user/escrow/index.blade.php ENDPATH**/ ?>