<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <div class="text-end">
                        <a href="<?php echo e(route('admin.escrow.milestone', $escrow->id)); ?>" class="btn btn-sm btn-outline--primary">
                            <?php echo app('translator')->get('See Milestones'); ?>
                            <i class="las la-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <h6 class="mb-3"><?php echo e(__($escrow->details)); ?> </h6>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Buyer'); ?></span>
                            <span><?php echo e(__(@$escrow->buyer->username ?? $escrow->invitation_mail)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Seller'); ?></span>
                            <span><?php echo e(__(@$escrow->seller->username ?? $escrow->invitation_mail)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Amount'); ?></span>
                            <span><?php echo e(showAmount($escrow->amount)); ?> </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Charge'); ?></span>
                            <span><?php echo e(showAmount($escrow->charge)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Charge Payer'); ?></span>
                            <span>
                                <?php if($escrow->charge_payer == Status::CHARGE_PAYER_SELLER): ?>
                                    <span class="badge badge--primary"><?php echo app('translator')->get('Seller'); ?></span>
                                <?php elseif($escrow->charge_payer == Status::CHARGE_PAYER_BUYER): ?>
                                    <span class="badge badge--dark"><?php echo app('translator')->get('Buyer'); ?></span>
                                <?php else: ?>
                                    <span class="badge badge--success"><?php echo app('translator')->get('50% - 50%'); ?></span>
                                <?php endif; ?>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Status'); ?></span>
                            <span>
                                <?php echo $escrow->escrowStatus ?>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Milestone Created'); ?></span>
                            <span><?php echo e(showAmount($escrow->milestones->sum('amount'))); ?> </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Milestone Funded'); ?></span>
                            <span><?php echo e(showAmount($escrow->milestones->where('payment_status', Status::MILESTONE_FUNDED)->sum('amount'))); ?>

                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Milestone Unfunded'); ?></span>
                            <span><?php echo e(showAmount($escrow->milestones->where('payment_status', Status::MILESTONE_UNFUNDED)->sum('amount'))); ?>

                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            <span class="fw-bold"><?php echo app('translator')->get('Rest Amount'); ?></span>
                            <span><?php echo e(showAmount($restAmount)); ?> </span>
                        </li>

                        <?php if($escrow->status == Status::ESCROW_DISPUTED): ?>
                            <li class="list-group-item d-flex justify-content-between">
                                <span class="fw-bold"><?php echo app('translator')->get('Disputed By'); ?></span>
                                <span><?php echo e(@$escrow->disputer->username); ?></span>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <?php if($escrow->status == Status::ESCROW_DISPUTED): ?>
                        <div class="mt-4">
                            <h5 class="text--danger"><?php echo app('translator')->get('Dispute Reason'); ?></h5>
                            <p><?php echo e(__($escrow->dispute_note)); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($escrow->status == Status::ESCROW_DISPUTED): ?>
                    <div class="card-footer">
                        <button class="btn btn--primary btn-sm w-100 h-45" data-bs-toggle="modal"
                            data-bs-target="#actionModal"><?php echo app('translator')->get('Take Action'); ?></button>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-md-6">
            <div class="msg-container">
                <div class="card">
                    <div class="card-header">
                        <div class="text-end">
                            <button class="btn btn--primary  btn-sm reloadButton">
                                <i class="las la-redo-alt me-0"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0 msg_history">
                        <div class="messaging p-3">
                            <div class="inbox_msg">
                                <ul class="msg-list d-flex flex-column">
                                    <?php if($messages->count() > 0): ?>
                                        <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $classText = $message->admin_id != 0 ? 'send' : 'receive';
                                            ?>
                                            <li class="msg-list__item">
                                                <div class="msg-<?php echo e($classText); ?>">
                                                    <?php if($escrow->status == Status::ESCROW_DISPUTED && $message->admin_id == 0): ?>
                                                        <p><?php echo e(@$message->sender->username ?? $message->admin->username); ?>

                                                        </p>
                                                    <?php endif; ?>
                                                    <div class="msg-<?php echo e($classText); ?>__content">
                                                        <p class="msg-<?php echo e($classText); ?>__text mb-0">
                                                            <?php echo e(__($message->message)); ?>

                                                        </p>
                                                    </div>
                                                    <ul
                                                        class="msg-<?php echo e($classText); ?>__history <?php if($classText == 'send'): ?> justify-content-end <?php endif; ?>">
                                                        <li class="msg-receive__history-item">
                                                            <?php echo e($message->created_at->format('h:i A')); ?>

                                                        </li>
                                                        <li class="msg-receive__history-item">
                                                            <?php echo e($message->created_at->diffForHumans()); ?>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="empty-message text-center ">
                                            <div class="empty-message__icon">
                                                <i class="fas fa-solid fa-comment-slash"></i>
                                            </div>
                                            <div class="empty-message__heading">
                                                <?php echo app('translator')->get('No conversation started yet'); ?>
                                            </div>

                                        </div>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($escrow->status == Status::ESCROW_DISPUTED): ?>
                    <div class="msg-option">
                        <form class="message-form">
                            <div class="msg-option__content rounded-pill">
                                <div class="msg-option__group ">
                                    <input type="text" class="form-control msg-option__input" name="message" autocomplete="off"
                                        placeholder="<?php echo app('translator')->get('Send Message'); ?>">
                                    <button type="submit" class=" btn btn--primary  rounded-pill">
                                        <i class="lab la-telegram-plane"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div id="actionModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Escrow Action'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.escrow.action')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="escrow_id" value="<?php echo e($escrow->id); ?>">

                    <div class="modal-body">
                        <div class="form-group mb-3">
                            <label class="fw-bold"><?php echo app('translator')->get('Total Funded Amount'); ?></label>
                            <div class="input-group">
                                <input type="text" class="form-control funded-amo"
                                    value="<?php echo e(getAmount($escrow->milestones->where('payment_status', 1)->sum('amount'))); ?>" readonly>

                                <span class="input-group-text">
                                    <?php echo e(__(gs('cur_text'))); ?>

                                </span>

                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label class="fw-bold"><?php echo app('translator')->get('Amount Send to Buyer'); ?></label>
                            <div class="input-group ">
                                <input type="number" step="any" name="buyer_amount" class="form-control range-calc" required>

                                <span class="input-group-text">
                                    <?php echo e(__(gs('cur_text'))); ?>

                                </span>

                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label class=" fw-bold"><?php echo app('translator')->get('Amount Send to Seller'); ?></label>
                            <div class="input-group ">
                                <input type="number" step="any" name="seller_amount" class="form-control range-calc" required>

                                <span class="input-group-text">
                                    <?php echo e(__(gs('cur_text'))); ?>

                                </span>

                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label class=" fw-bold"><?php echo app('translator')->get('Charge'); ?></label>
                            <div class="input-group ">
                                <input type="text" class="form-control charge" readonly>

                                <span class="input-group-text">
                                    <?php echo e(__(gs('cur_text'))); ?>

                                </span>

                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <label class="fw-bold"><?php echo app('translator')->get('Select Status'); ?></label>
                            <select name="status" class="form-control form-select-sm" required>
                                <option value="1"><?php echo app('translator')->get('Completed'); ?></option>
                                <option value="9"><?php echo app('translator')->get('Cancelled'); ?></option>
                            </select>
                        </div>
                        <div class="form-gorup">
                            <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/chat.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .msg-option__input:focus {
            box-shadow: none;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            $(".msg_history").animate({
                scrollTop: $('.msg_history').prop("scrollHeight")
            }, 1);


            $('.message-form').on("submit", function(e) {
                e.preventDefault();
                $(this).find('button[type=submit]').removeAttr('disabled');
                var url = "<?php echo e(route('admin.escrow.message.reply')); ?>";

                var data = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    conversation_id: "<?php echo e($conversation->id); ?>",
                    message: $(this).find('[name=message]').val()
                }

                $.post(url, data, function(response) {
                    if (response['error']) {
                        $.each(response['error'], function(i, v) {
                            notify('error', v);
                        });
                        return true;
                    }

                    var html = `
                            <li class="msg-list__item">
                                <div class="msg-send">
                                    <div class="msg-send__content">
                                        <p class="msg-send__text mb-0">
                                            ${response['message']}
                                        </p>
                                    </div>
                                    <ul class="msg-send__history  justify-content-end ">
                                        <li class="msg-receive__history-item">${response['created_time']}</li>
                                        <li class="msg-receive__history-item">${response['created_diff']}</li>
                                    </ul>
                                </div>
                            </li>
                    `;

                    $('.msg-list').append(html);
                    $(".msg_history").animate({
                        scrollTop: $('.msg_history').prop("scrollHeight")
                    }, 1);
                });
                $(this).find('[name=message]').val('')

            });

            $('.reloadButton').on("click", function() {
                var url = '<?php echo e(route('admin.escrow.message.get')); ?>';
                var data = {
                    conversation_id: "<?php echo e($conversation->id); ?>"
                }
                $.get(url, data, function(response) {
                    if (response['error']) {
                        $.each(response['error'], function(i, v) {
                            notify('error', v);
                        });
                        return true;
                    }
                    $('.msg-list').html(response);
                    $(".msg_history").animate({
                        scrollTop: $('.msg_history').prop("scrollHeight")
                    }, 1);

                });

            });

            $('.range-calc').on('input', function() {
                var buyerAmo = $('[name=buyer_amount]').val();
                if (!buyerAmo) {
                    buyerAmo = 0;
                }
                var sellerAmo = $('[name=seller_amount]').val();

                if (!sellerAmo) {
                    sellerAmo = 0;
                }
                chargeCalculator(buyerAmo, sellerAmo)
            });

            function chargeCalculator(buyerAmo, sellerAmo) {
                var fundedAmo = $('.funded-amo').val();
                var charge = fundedAmo - (parseFloat(buyerAmo) + parseFloat(sellerAmo));
                if (charge < 0) {
                    notify('error', 'You couldn\'t transact greater than funded amount');
                    return false;
                }
                $('.charge').val(charge);
            }

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/U.S/Arizona/GreatAmericanTitle/core/resources/views/admin/escrow/details.blade.php ENDPATH**/ ?>