<header class="header-fixed header--primary">
    <div class="container">
        <div class="row g-0 align-items-center">
            <div class="col-6 col-lg-2">
                <a class="logo" href="<?php echo e(route('home')); ?>">
                    <img alt="<?php echo app('translator')->get('image'); ?>" class="img-fluid logo__is" src="<?php echo e(siteLogo()); ?>">
                </a>
            </div>
            <div class="col-6 col-lg-10">
                <div class="nav-container">
                    <!-- Navigation Toggler  -->
                    <div class="d-flex justify-content-end align-items-center d-xl-none">
                        <button class="btn p-0 nav--toggle header-button text-white" type="button">
                            <i class="las la-bars"></i>
                        </button>
                    </div>
                    <!-- Navigation Toggler End -->

                    <!-- Navigation  -->
                    <nav class="navs">
                        <!-- Primary Menu  -->
                        <div class="header-menu">
                            <ul class="list primary-menu primary-menu--alt">
                                <li class="primary-menu__list">
                                    <a class="primary-menu__link" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                                </li>

                                <?php if((auth()->user() && request()->routeIs('user.*')) || (auth()->user() && request()->routeIs('ticket*'))): ?>

                                    <li class="primary-menu__list has-sub">
                                        <a class="primary-menu__link" href="javascript:void(0)"><?php echo app('translator')->get('Deposit'); ?></a>

                                        <ul class="primary-menu__sub">
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link"
                                                    href="<?php echo e(route('user.deposit.index')); ?>"><?php echo app('translator')->get('Deposit Now'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link"
                                                    href="<?php echo e(route('user.deposit.history')); ?>"><?php echo app('translator')->get('Deposit Log'); ?></a>
                                            </li>
                                        </ul>
                                    </li>

                                    <li class="primary-menu__list has-sub">
                                        <a class="primary-menu__link" href="javascript:void(0)">
                                            <?php echo app('translator')->get('Escrow'); ?>
                                        </a>

                                        <ul class="primary-menu__sub">
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('user.escrow.step.one')); ?>">
                                                    <?php echo app('translator')->get('New Escrow'); ?>
                                                </a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('user.escrow.index')); ?>">
                                                    <?php echo app('translator')->get('All Escrow'); ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>

                                    <li class="primary-menu__list has-sub">
                                        <a class="primary-menu__link" href="javascript:void(0)"><?php echo app('translator')->get('Withdraw'); ?></a>

                                        <ul class="primary-menu__sub">
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('user.withdraw')); ?>"><?php echo app('translator')->get('Withdraw Now'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link"
                                                    href="<?php echo e(route('user.withdraw.history')); ?>"><?php echo app('translator')->get('Withdrawal Log'); ?></a>
                                            </li>
                                        </ul>
                                    </li>

                                    <li class="primary-menu__list">
                                        <a class="primary-menu__link" href="<?php echo e(route('user.transactions')); ?>"><?php echo app('translator')->get('Transactions'); ?></a>
                                    </li>

                                    <li class="primary-menu__list has-sub">
                                        <a class="primary-menu__link" href="javascript:void(0)"><?php echo e(auth()->user()->username); ?></a>

                                        <ul class="primary-menu__sub">
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Tickets'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('ticket.open')); ?>"><?php echo app('translator')->get('Open New Ticket'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link"
                                                    href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link"
                                                    href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile Setting'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a>
                                            </li>
                                            <li class="primary-menu__sub-list">
                                                <a class="t-link primary-menu__sub-link" href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a>
                                            </li>
                                        </ul>
                                    </li>
                                <?php else: ?>
                                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="primary-menu__list">
                                            <a class="primary-menu__link" href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <li class="primary-menu__list">
                                        <a class="primary-menu__link" href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blogs'); ?></a>
                                    </li>

                                    <li class="primary-menu__list">
                                        <a class="primary-menu__link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                                    </li>
                                <?php endif; ?>
                                <li class="language_switcher me-3">
                                    <?php if(gs('multi_language')): ?>
                                        <?php
                                            $language = App\Models\Language::all();
                                            $selectLang = $language->where('code', config('app.locale'))->first();

                                        ?>
                                        <div class="language_switcher__caption">
                                            <span class="icon">
                                                <img src="<?php echo e(getImage(getFilePath('language') . '/' . $selectLang->image, getFileSize('language'))); ?>"
                                                    alt="<?php echo app('translator')->get('image'); ?>">
                                            </span>
                                            <span class="text"> <?php echo e(__(@$selectLang->name)); ?> </span>
                                        </div>
                                        <div class="language_switcher__list">
                                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="language_switcher__item    <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>"
                                                    data-value="<?php echo e($item->code); ?>">
                                                    <a href="<?php echo e(route('lang', $item->code)); ?>" class="thumb">
                                                        <span class="icon">
                                                            <img src="<?php echo e(getImage(getFilePath('language') . '/' . $item->image, getFileSize('language'))); ?>"
                                                                alt="<?php echo app('translator')->get('image'); ?>">
                                                        </span>
                                                        <span class="text"> <?php echo e(__($item->name)); ?></span>
                                                    </a>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </li>
                                <?php if(auth()->guard()->guest()): ?>
                                    <li class="primary-menu__list">
                                        <a class="btn btn-base--outline " href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                                        <a class="btn btn--md btn--base  ms-3" href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Join Now'); ?></a>
                                    </li>
                                <?php else: ?>
                                    <li class="primary-menu__list">
                                        <a class="btn btn--md btn-base--outline " href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <!-- User Login End -->
                    </nav>
                    <!-- Navigation End -->
                </div>
            </div>
        </div>
    </div>
</header>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(".langSel").on("change", function() {
                window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).val();
            });

            $('.language_switcher > .language_switcher__caption').on('click', function() {
                $(this).parent().toggleClass('open');
            });

            $(document).on('keyup', function(evt) {
                if ((evt.keyCode || evt.which) === 27) {
                    $('.language_switcher').removeClass('open');
                }
            });

            $(document).on('click', function(evt) {
                if ($(evt.target).closest(".language_switcher > .language_switcher__caption").length === 0) {
                    $('.language_switcher').removeClass('open');
                }
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        /* language */
        .language_switcher {
            position: relative;
            padding-right: 20px;
            min-width: max-content;
        }

        @media(max-width: 1199px) {
            .language_switcher {
                padding-block: 6px;
                display: inline-flex;
                margin-bottom: 24px;
                max-width: max-content;

            }

            .language_switcher_wrapper {
                flex: 1;
                text-align: right;
            }
        }

        .language_switcher::after {
            font-family: 'Line Awesome Free';
            content: "\f107";
            font-weight: 900;
            font-size: 14px;
            position: absolute;
            margin: 0;
            color: white;
            top: 50%;
            right: 0;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
            transition: all ease 350ms;
            -webkit-transition: all ease 350ms;
            -moz-transition: all ease 350ms;
        }

        .language_switcher.open:after {
            -webkit-transform: translateY(-50%) rotate(180deg);
            transform: translateY(-50%) rotate(180deg);
        }

        .language_switcher__caption {
            cursor: pointer;
            padding: 0;
            display: flex;
            align-items: center;
            gap: 4px;
            flex-wrap: nowrap;
        }

        .language_switcher__caption .icon {
            position: relative;
            height: 20px;
            width: 20px;
            display: flex;
        }

        .language_switcher__caption .icon img {
            height: 100%;
            width: 100%;
            border-radius: 50%;
            object-fit: cover;
        }

        .language_switcher__caption .text {
            font-size: 0.875rem;
            font-weight: 500;
            flex: 1;
            color: white;
            line-height: 1;
        }

        .language_switcher__list {
            width: 100px;
            border-radius: 4px;
            padding: 0;
            max-height: 105px;
            overflow-y: auto !important;
            background: #fff;
            -webkit-box-shadow: 0px 12px 24px rgba(21, 18, 51, 0.13);
            opacity: 0;
            overflow: hidden;
            -webkit-transition: all 0.15s cubic-bezier(0.25, 0, 0.25, 1.75),
                opacity 0.1s linear;
            transition: all 0.15s cubic-bezier(0.25, 0, 0.25, 1.75), opacity 0.1s linear;
            -webkit-transform: scale(0.85);
            transform: scale(0.85);
            -webkit-transform-origin: 50% 0;
            transform-origin: 50% 0;
            position: absolute;
            top: calc(100% + 18px);
            z-index: -1;
            visibility: hidden;
            border: 1px solid rgb(0 0 0 / 10%);
        }

        .language_switcher__list::-webkit-scrollbar-track {
            border-radius: 3px;
            background-color: hsl(var(--base) / 0.3);
        }

        .language_switcher__list::-webkit-scrollbar {
            width: 3px;
        }

        .language_switcher__list::-webkit-scrollbar-thumb {
            border-radius: 3px;
            background-color: hsl(var(--base) / 0.8);
        }

        .language_switcher__list .text {
            font-size: 0.875rem;
            font-weight: 500;
            color: black;
        }

        .language_switcher.open .language_switcher__list {
            -webkit-transform: scale(1);
            transform: scale(1);
            opacity: 1;
            z-index: 1;
            visibility: visible;
        }

        .language_switcher__item a {
            cursor: pointer;
            padding: 5px;
            border-bottom: 1px solid hsl(var(--heading-color) / 0.2);
            display: flex;
            align-items: center;
            gap: 4px;
            text-decoration: none;
        }

        .language_switcher__item img {
            height: 20px;
            width: 20px;
            display: block;
            border-radius: 50%;
        }

        .language_switcher__item:last-of-type {
            border-bottom: 0;
        }

        .language_switcher__item.selected {
            background: rgba(36, 60, 187, 0.02);
            pointer-events: none;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ulsitlqp/titleagency.it.com/title/escrow/account/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>