<?php $__env->startSection('content'); ?>
    <section class="section bg--light">
        <div class="container">
            <div class="row justify-content-center g-4">
                <div class="col-md-6">
                    <div class="card custom--card">
                        <div class="card-body">
                            <form action="<?php echo e(route('user.escrow.step.two.submit')); ?>" method="POST">
                                <?php echo csrf_field(); ?>

                                <div class="form-group">
                                    <label class="d-block mb-2 sm-text">
                                        <?php if($escrowInfo['type'] == 1): ?>
                                            <?php echo app('translator')->get('Buyer\'s'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('Seller\'s'); ?>
                                        <?php endif; ?> <?php echo app('translator')->get('Email'); ?>
                                    </label>
                                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo app('translator')->get('Enter email'); ?>"
                                        class="form-control form--control" required>
                                </div>
                                <div class="form-group">
                                    <label class="d-block mb-2 sm-text"><?php echo app('translator')->get('Title'); ?></label>
                                    <input type="text" name="title" value="<?php echo e(old('title')); ?>" placeholder="<?php echo app('translator')->get('Enter title'); ?>"
                                        class="form-control form--control" required>
                                </div>

                                <div class="form-group">
                                    <label class="d-block mb-2 sm-text"><?php echo app('translator')->get('Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control form--control" value="<?php echo e(getAmount($escrowInfo['amount'])); ?>" readonly>
                                        <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="d-block mb-2 sm-text"><?php echo app('translator')->get('Charge'); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control form--control" value="<?php echo e(getAmount($escrowInfo['charge'])); ?>" readonly>
                                        <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                                    </div>
                                </div>
                                <div class="form-group select2-parent">
                                    <label class="d-block mb-2 sm-text"><?php echo app('translator')->get('Charge will Pay'); ?></label>

                                    <select name="charge_payer" class="form-control select2-basic" data-minimum-results-for-search="-1" required>
                                        <option value="1"><?php echo app('translator')->get('Seller'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('Buyer'); ?></option>
                                        <option value="3"><?php echo app('translator')->get('50% - 50%'); ?></option>
                                    </select>

                                </div>
                                <div class="form-group">
                                    <label class="d-block mb-2 sm-text"><?php echo app('translator')->get('Details'); ?></label>
                                    <textarea name="details" class="form-control form--control-textarea" rows="5" placeholder="<?php echo app('translator')->get('Enter details'); ?>"><?php echo e(old('details')); ?></textarea>
                                </div>
                                <button type="submit" class="btn btn--base w-100 h-45"><?php echo app('translator')->get('Next'); ?></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/title/escrow/account/core/resources/views/templates/basic/user/escrow/step_two.blade.php ENDPATH**/ ?>