<?php $__env->startSection('content'); ?>
    <section class="section bg--light">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="show-filter mb-3 text-end">
                        <button type="button" class="btn btn--base showFilterBtn btn-sm">
                            <i class="las la-filter"></i>
                            <?php echo app('translator')->get('Filter'); ?>
                        </button>
                    </div>

                    <div class="card responsive-filter-card mb-4 custom--card">
                        <div class="card-body">
                            <form>
                                <div class="d-flex flex-wrap gap-4">
                                    <div class="flex-grow-1">
                                        <label class="form-label"><?php echo app('translator')->get('Transaction Number'); ?></label>
                                        <input type="search" name="search" value="<?php echo e(request()->search); ?>"
                                            class="form-control form--control">
                                    </div>
                                    <div class="flex-grow-1 select2-parent">
                                        <label class="form-label d-block"><?php echo app('translator')->get('Type'); ?></label>
                                        <select name="trx_type" class="form-select form--control select2-basic"
                                            data-minimum-results-for-search="-1">
                                            <option value=""><?php echo app('translator')->get('All'); ?></option>
                                            <option value="+" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus'); ?></option>
                                            <option value="-" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus'); ?></option>
                                        </select>
                                    </div>
                                    <div class="flex-grow-1 select2-parent">
                                        <label class="form-label d-block"><?php echo app('translator')->get('Remark'); ?></label>
                                        <select class="form-select form--control select2-basic"
                                            data-minimum-results-for-search="-1" name="remark">
                                            <option value=""><?php echo app('translator')->get('All'); ?></option>
                                            <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($remark->remark); ?>" <?php if(request()->remark == $remark->remark): echo 'selected'; endif; ?>>
                                                    <?php echo e(__(keyToTitle($remark->remark))); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="flex-grow-1 align-self-end">
                                        <button class="btn btn--base w-100 h-50">
                                            <i class="las la-filter"></i>
                                            <?php echo app('translator')->get('Filter'); ?>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <table class="table custom--table table-responsive--md">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Trx'); ?></th>
                                <th><?php echo app('translator')->get('Transacted'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                                <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                <th><?php echo app('translator')->get('Detail'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($trx->trx); ?></strong>
                                    </td>
                                    <td>
                                        <?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?>

                                    </td>
                                    <td class="budget">
                                        <span
                                            class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                                            <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?>


                                        </span>
                                    </td>
                                    <td class="budget">
                                        <?php echo e(showAmount($trx->post_balance)); ?>

                                    </td>
                                    <td><?php echo e(__($trx->details)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <?php if($transactions->hasPages()): ?>
                        <div class="mt-3">
                            <?php echo e(paginateLinks($transactions)); ?>

                        </div>
                    <?php endif; ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .select2-container:has(.select2-selection--single) {
            width: 100% !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/GreatAmericanTitleAgency/Verified☑️/core/resources/views/templates/basic/user/transactions.blade.php ENDPATH**/ ?>